package test.xml;


import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;

public class TableInfo {

	private TreeMap<String, ColumnInfo> columnInfoMap = new TreeMap<String, ColumnInfo>(new ComparatorString2Int()) ;		// e[uŗL̃Ji[
	private TreeMap<String, ColumnInfo> primaryKeyMap = new TreeMap<String, ColumnInfo>(new ComparatorString2Int()) ;		// vC}[L[i_L[ji[

	public String toString() {
		StringBuffer sBuff = new StringBuffer();
		sBuff.append( "[TableName=" + getTableName() + "]");
		sBuff.append( "[TableNameKnj=" + getTableNameKnj() + "]");
		sBuff.append( "[TableType=" + getTableType() + "]");

		sBuff.append( "[comcrtYMD=" + getComcrtYMD() + "]");
		sBuff.append( "[comcrtShainCod=" + getComcrtShainCod() + "]");
		sBuff.append( "[comupdYMD=" + getComupdYMD() + "]");
		sBuff.append( "[comupdShainCod=" + getComupdShainCod() + "]");

		return sBuff.toString();
	}

//	------------------------------< ϐݒ >
	private String tableName = "";
	private String tableNameKnj = "";
	private String tableType = "";

	private String comcrtYMD;
	private String comcrtShainCod;
	private String comupdYMD;
	private String comupdShainCod;

	//	------------------------------< setter` >
	public void setTableName(String sVal){ this.tableName=sVal; }
	public void setTableNameKnj(String sVal){ this.tableNameKnj=sVal; }
	public void setTableType(String sVal){ this.tableType=sVal; }

	public void setComcrtYMD(String sVal){ this.comcrtYMD=sVal; }
	public void setComcrtShainCod(String sVal){ this.comcrtShainCod=sVal; }
	public void setComupdYMD(String sVal){ this.comupdYMD=sVal; }
	public void setComupdShainCod(String sVal){ this.comupdShainCod=sVal; }
//	------------------------------< getter` >
	public String getTableName(){ return this.tableName; }
	public String getTableNameKnj(){ return this.tableNameKnj; }
	public String getTableType(){ return this.tableType; }

	public String getComcrtYMD(){ return this.comcrtYMD; }
	public String getComcrtShainCod(){ return this.comcrtShainCod; }
	public String getComupdYMD(){ return this.comupdYMD; }
	public String getComupdShainCod(){ return this.comupdShainCod; }

	public TreeMap<String, ColumnInfo> getPrimaryKeyMap() {
		return primaryKeyMap;
	}
	public TreeMap<String, ColumnInfo> getColumnMap() {
		return columnInfoMap ;
	}

	private List<ColumnInfo> columnList;
	public List<ColumnInfo> getColumnList() {
		return this.columnList;
	}
	public void setColumnList(List<ColumnInfo> columnList) {
		this.columnList = columnList;
		columnInfoMap.clear();
		for (ColumnInfo columnInfo : columnList) {
			columnInfoMap.put(String.valueOf(columnInfo.getColumnId()), columnInfo);

			// vC}[L[i_L[j̏ꍇ
			if (columnInfo.getPrimaryKeyNo() > 0) {
				primaryKeyMap.put(String.valueOf(columnInfo.getPrimaryKeyNo()), columnInfo);
			}
		}
	}

	public ColumnInfo getColumn(String columnName) {
		ColumnInfo retCol = null ;

		for (String key : columnInfoMap.keySet()) {
			ColumnInfo column = columnInfoMap.get(key);

			if (column.getColumnName().equalsIgnoreCase(columnName)) {
				retCol = column;
				break ;
			}
		}
		return retCol;
	}

	private class ComparatorString2Int implements Comparator<Object> {

		public ComparatorString2Int() {
			super();
		}

		public int compare(Object arg0, Object arg1) {
			int nArg0 = Integer.parseInt((String)arg0);
			int nArg1 = Integer.parseInt((String)arg1);

			return (nArg0 - nArg1);
		}

}

}
